#version 330
#extension GL_EXT_gpu_shader4 : enable
// Mandelbrot - ATMod01.fsh  by   athibaul 

//https://www.shadertoy.com/view/fdt3zX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 cmul(vec2 a, vec2 b)
{
    return vec2(a.x*b.x - a.y*b.y, a.x*b.y + a.y*b.x);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*gl_FragCoord.xy -iResolution.xy)/iResolution.y;
    vec2 mouseUV = (2.*iMouse.xy-iResolution.xy)/iResolution.y;
    
    float ITER = 100.;
    
    if(iMouse.z > 0.)
    {
        // Magnification around the mouse position
        uv = mouseUV + 0.1*uv;
        ITER = 200.;
    }

    vec2 z = vec2(0);
    float zz;
    vec2 zmin = z;
    float zzmin = 1000.;
    float i;
    for(i=0.; i<ITER; i++)
    {
        // The loop to determine whether a point is inside or outside
        z = cmul(z, z) + uv;
        zz = dot(z,z);
        //zzmin = min(zz, zzmin);
        if(zz < zzmin)
        {
            zzmin = zz;
            zmin = z;
        }
        if(zz > 1000.) break;
    }
    
    vec3 col;
    if(i < ITER)
    {
        // We're outside!
        // Color outside according to the rate of exit
        // https://en.wikipedia.org/wiki/Plotting_algorithms_for_the_Mandelbrot_set#Continuous_(smooth)_coloring
        float phi = log2(zz)/exp2(i);
        col = 0.5 + 0.5*cos(log2(phi) + vec3(0,1,2) - iTime);
        col *= smoothstep(0.8,0.,phi);
    }
    else
    {
        //col = 0.5 + 0.5*cos(0.5*round(iTime+6.*z.xyx)+vec3(0,1,2));
        //col = 0.5 + 0.5*cos(iTime+3.*z.xyx+vec3(0,1,2));
        
        // Color inside according to smallest absolute value of the orbit
        col = 0.5 + 0.5*cos(iTime+log(zzmin) + vec3(0,1,2));
        //col = (0.5 + 0.5*cos(iTime+log(zzmin))) * vec3(0.1,0.5,1.);
        
        // Color according to the point whose orbit goes nearest the origin
        vec3 col2 = 0.5 + 0.5*cos(iTime+zmin.yyy/zzmin+vec3(0,1,2));
        //col += (0.5 + 0.5*cos(iTime+5.*zmin.yyy)) * vec3(1., 0.5, 0.1);
        
        float limit = 0.1 + 0.09*cos(0.618*iTime + uv.x);
        col = mix(col, col2, smoothstep(0.0,limit,zzmin));
        
        //col = sqrt(1.-exp(-col));
    }

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}